/** @file   display.h
 * @brief   Declaration of Display class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:39 $
 * @author  Tomi Lamminsaari
 */


#include "display.h"
#include <allegro.h>

namespace eng2d {

//********************************************************************
//                                                                   *
//      Static members and constants                                 *
//                                                                   *
//********************************************************************

BITMAP* Display::buffer = 0;

Display::Method Display::updateMethod = DOUBLEBUFFER;



/** Establishes the given screenmode. 
 */
int Display::setUp(int width, int height, int depth, Method m)
{
  if ( m == DOUBLEBUFFER ) {

    updateMethod = DOUBLEBUFFER;
    
    // Set up the screenmode
    set_color_depth(depth);
    int success = set_gfx_mode(GFX_AUTODETECT, width, height, 0,0);
    if ( success < 0 ) {
      return success;
    }
    
    // Create the double buffer.
    buffer = create_bitmap(width, height);
    if ( buffer == 0 ) {
      textmode();
      return -1;
    }
    return 0;
    
  }
  return -1;
}



/** Sets up the doublebuffered screen
 */
int Display::setUpDB(int width, int height, int depth)
{
  updateMethod = DOUBLEBUFFER;
  set_color_depth(depth);
  int success = set_gfx_mode(GFX_AUTODETECT, width, height, 0,0);
  if ( success < 0 ) {
    return success;
  }
  
  // Create the double buffer
  buffer = create_bitmap(width, height);
  if ( buffer == 0 ) {
    textmode();
    return -1;
  }
  return 0;
}



/** Closes the current screenmode and restores the windows desktop
 */
void Display::textmode()
{
  // Destroy the double buffer.
  if ( updateMethod == DOUBLEBUFFER ) {
    if ( buffer != 0 ) {
      destroy_bitmap( buffer );
      buffer = 0;
    }
  }
  
  // Restore the previus screenmode.
  set_gfx_mode(GFX_TEXT, 0,0, 0,0);
}



/** Flips the buffer to screen. If update method is DOUBLEBUFFER, we just
 * blit the contents of it to the screen. If it's page flip, we change
 * the visible part of video ram
 */
void Display::flip()
{
  if ( updateMethod == DOUBLEBUFFER ) {
    blit(buffer, screen, 0,0, 0,0, buffer->w, buffer->h);
  }
}



/** Flips only given part of the hidden buffer to the screen. Only for
 * doublebuffered mode.
 */
void Display::flip(int x, int y, int w, int h)
{
  if ( updateMethod == DOUBLEBUFFER ) {
    blit(buffer, screen, x,y, x,y, w,h);
  }
}



/** Returns the width of current screenmode
 */
int Display::scrWidth()
{
  return SCREEN_W;
}



/** Returns the height of current screenmode
 */
int Display::scrHeight()
{
  return SCREEN_H;
}



}
